Imports System.IO
Imports MySql.Data
Imports MySql.Data.MySqlClient
Imports iTextSharp.text
Imports iTextSharp.text.pdf
Imports iTextSharp.text.SimpleTable
Imports System.Data

Partial Class Select_MySQL
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        ' When the page loads we get data from session variables to us in our select statements

        If Page.IsPostBack = False Then
            HiddenCompanyID.Value = Convert.ToString(Session("CompanyID"))
            HiddenYearID.Value = Convert.ToString(Session("YearID"))
            HiddenCompanyName.Value = Convert.ToString(Session("CompanyName"))
        End If
    End Sub
    Protected Sub BtnSelectAssets_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles BtnSelectAssets.Click

        ' This is code to select data to a dataset with two tables so that we kan make groups and calculate values.
        ' Asset accounts are inserted in parentrepeater and assets are inserted inside a childrepeater.

        Try
            Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
            Dim sql As String = "SELECT AssetTypeID, AssetAccount, TypeName FROM AssetType WHERE CompanyID = @CompanyID GROUP BY AssetTypeID, AssetAccount, TypeName ORDER BY AssetAccount ASC"
            Dim sql2 As String = "SELECT A.AssetOwnID, A.AssetType, A.AssetName, A.PurchaseDate, A.PurchasePrice, SUM(COALESCE(SumIB, 0)) As YearIB, SUM(COALESCE(SumYearDep,0)) As YearDep, SUM(COALESCE(SumIB, 0) + COALESCE(SumYearDep,0)) As SumAckDeprication, SUM(A.PurchasePrice - (COALESCE(SumIB, 0) + COALESCE(SumYearDep,0))) As AccountedValue FROM Assets AS A LEFT OUTER JOIN (SELECT AssetID, SUM(IBValue) As SumIB FROM IBDeprication WHERE YearID = @YearID GROUP BY AssetID) As IB ON A.AssetID = IB.AssetID LEFT OUTER JOIN (SELECT AssetID, SUM(DepricationValue) As SumYearDep FROM Deprication WHERE YearID = @YearID GROUP BY AssetID) AS D ON A.AssetID = D.AssetID WHERE A.CompanyID = @CompanyID AND A.SoldScraped = '0' OR A.DateSold > @Slutdatum GROUP BY A.AssetOwnID, A.AssetType, A.AssetName, A.PurchaseDate, A.PurchasePrice ORDER BY A.PurchaseDate ASC"

            ' The Using block is used to call dispose (close) automatically even if there are an exception.
            Using cn As New MySqlConnection(ConnString), _
                ad As New MySqlDataAdapter(), _
                cmd As New MySqlCommand(sql, cn), _
                ad2 As New MySqlDataAdapter(), _
                cmd2 As New MySqlCommand(sql2, cn)
                cmd.Parameters.Add("@CompanyID", MySqlDbType.Int64).Value = HiddenCompanyID.Value
                cmd2.Parameters.Add("@YearID", MySqlDbType.Int64).Value = HiddenYearID.Value
                cmd2.Parameters.Add("@CompanyID", MySqlDbType.Int64).Value = HiddenCompanyID.Value
                cmd2.Parameters.Add("@Slutdatum", MySqlDbType.Date).Value = txtEndDate.Text

                cn.Open()

                ' Fill dataset with assettypes as first table
                ad.SelectCommand = cmd

                ' The Using block is used to call dispose (close) automatically even if there are an exception.
                Using ds As New DataSet()

                    ad.Fill(ds, "AssetTypes")

                    ' Fill dataset with assets as second table
                    ad2.SelectCommand = cmd2
                    ad2.Fill(ds, "Assets")

                    ' Create the relation bewtween the AssetTypes and Assets tables.
                    ds.Relations.Add("assetsrelation", ds.Tables("AssetTypes").Columns("AssetTypeID"), ds.Tables("Assets").Columns("AssetType"))

                    ' Calculate subtotals
                    Dim PPTotal As DataColumn = New DataColumn("PPTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).PurchasePrice)")
                    PPTotal.AutoIncrement = False
                    PPTotal.ReadOnly = True
                    Dim IBTotal As DataColumn = New DataColumn("IBtotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).YearIB)")
                    IBTotal.AutoIncrement = False
                    IBTotal.ReadOnly = True
                    Dim YearTotal As DataColumn = New DataColumn("YearDepTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).YearDep)")
                    YearTotal.AutoIncrement = False
                    YearTotal.ReadOnly = True
                    Dim AckDepTotal As DataColumn = New DataColumn("AckDepTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).SumAckDeprication)")
                    AckDepTotal.AutoIncrement = False
                    AckDepTotal.ReadOnly = True
                    Dim AccValueTotal As DataColumn = New DataColumn("AccValueTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).AccountedValue)")
                    AccValueTotal.AutoIncrement = False
                    AccValueTotal.ReadOnly = True

                    ' Add columns to table AssetTypes
                    ds.Tables("AssetTypes").Columns.Add(PPTotal)
                    ds.Tables("AssetTypes").Columns.Add(IBTotal)
                    ds.Tables("AssetTypes").Columns.Add(YearTotal)
                    ds.Tables("AssetTypes").Columns.Add(AckDepTotal)
                    ds.Tables("AssetTypes").Columns.Add(AccValueTotal)

                    ' Bind the AssetTypes table to the parentrepeater control, and call DataBind. Data for the 
                    ' childrepeater gets in Create-pdf.aspx from the dataset.
                    parentRepeater.DataSource = ds.Tables("AssetTypes")
                    Page.DataBind()
                End Using

            End Using
        Catch ex As Exception
            Response.Write(ex.Message)
        End Try
    End Sub
    Protected Sub btnPrintKvarAnlagg_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnPrintKvarAnlagg.Click

        ' This code creates a pdf (itextsharp) that the user can download after the user has clicked the "Print report" button. The data
        ' for the pdf report are each row in the repeater control. You need to have the file "itextsharp.dll" in the "bin"
        ' folder to be able to create pdf reports according to this example.

        'Create pdf document and set margins
        Dim PdfDocument As New Document(PageSize.A4)
        PdfWriter.GetInstance(PdfDocument, Response.OutputStream)

        'IF YOU WANT TO SAVE THE PDF TO THE WEBSERVER YOU CAN USE THIS EXAMPLE CODE INSTEAD OF THE ROW ABOVE
        'Dim AssetUser As String = Page.User.Identity.Name
        'Dim SavePdf As String = "pdf/" & AssetUser.Replace(".", "") & ".pdf"
        'PdfWriter.GetInstance(PdfDocument, New FileStream(Server.MapPath(SavePdf), FileMode.Create))

        PdfDocument.SetMargins(43, 43, 43, 43)

        ' Fonts that can be used in this document
        Dim calibri As BaseFont = BaseFont.CreateFont(Server.MapPath("fonts/Calibri.TTF"), BaseFont.WINANSI, BaseFont.EMBEDDED)
        Dim BoldHeading As Font = New Font(calibri, 20, Font.BOLD)
        Dim BoldText As Font = New Font(calibri, 12, Font.BOLD)
        Dim Text As Font = New Font(calibri, 12)
        Dim MiddleBoldText As Font = New Font(calibri, 8, Font.BOLD)
        Dim MiddleItalicText As Font = New Font(calibri, 8, Font.ITALIC)
        Dim MiddleText As Font = New Font(calibri, 8)

        ' we add a footer
        Dim FooterOne As HeaderFooter = New HeaderFooter(New Phrase("", BoldText), True)
        FooterOne.Alignment = ALIGN_RIGHT
        FooterOne.Border = NO_BORDER
        PdfDocument.Footer = FooterOne

        PdfDocument.Open()

        Dim CompanyP1 As Paragraph = New Paragraph(HiddenCompanyName.Value, BoldText)
        Dim Heading As Paragraph = New Paragraph("Kvarvarande anlggningstillgngar", BoldHeading)
        Dim EndDate As Paragraph = New Paragraph("End date: " & txtEndDate.Text, Text)
        Dim PrintDate As Paragraph = New Paragraph("Date printed: " & DateTime.Now.ToString("yyyy-MM-dd"), Text)
        CompanyP1.Alignment = Element.ALIGN_LEFT
        Heading.Alignment = Element.ALIGN_CENTER
        EndDate.Alignment = Element.ALIGN_LEFT
        PrintDate.Alignment = Element.ALIGN_LEFT
        PdfDocument.Add(CompanyP1)
        PdfDocument.Add(Heading)
        PdfDocument.Add(New Paragraph(" ", Text))
        PdfDocument.Add(EndDate)
        PdfDocument.Add(PrintDate)

        PdfDocument.Add(New Paragraph(" ", Text))

        ' Create the first and only table
        Dim AnlaggningarTable As New PdfPTable(8)
        AnlaggningarTable.HorizontalAlignment = ALIGN_LEFT
        Dim sWidths() As Single = {10, 20, 10, 12, 12, 12, 12, 12}
        AnlaggningarTable.SetTotalWidth(sWidths)
        AnlaggningarTable.WidthPercentage = 100
        AnlaggningarTable.DefaultCell.Border = 0

        AnlaggningarTable.DefaultCell.BorderWidthTop = 1
        AnlaggningarTable.DefaultCell.BorderWidthBottom = 1
        AnlaggningarTable.AddCell(New Phrase("Asset ID", MiddleBoldText))
        AnlaggningarTable.AddCell(New Phrase("Name", MiddleBoldText))
        AnlaggningarTable.AddCell(New Phrase("Purch. date", MiddleBoldText))
        AnlaggningarTable.DefaultCell.HorizontalAlignment = ALIGN_RIGHT
        AnlaggningarTable.AddCell(New Phrase("Cost", MiddleBoldText))
        AnlaggningarTable.AddCell(New Phrase("OB acc. depr.", MiddleBoldText))
        AnlaggningarTable.AddCell(New Phrase("Year deprication", MiddleBoldText))
        AnlaggningarTable.AddCell(New Phrase("Acc. depr.", MiddleBoldText))
        AnlaggningarTable.AddCell(New Phrase("Book value", MiddleBoldText))

        AnlaggningarTable.DefaultCell.Border = 0

        ' Fill the report with parent rows from the repeater control
        For Each RepeaterRow As RepeaterItem In parentRepeater.Items

            Dim AssetAccountLiteralObj As Literal = DirectCast(RepeaterRow.FindControl("AssetAccountLiteral"), Literal)
            Dim AssetTypeNameLiteralObj As Literal = DirectCast(RepeaterRow.FindControl("AssetTypeNameLiteral"), Literal)
            Dim PPpriceLabelObj As Label = DirectCast(RepeaterRow.FindControl("PPpriceLabel"), Label)
            Dim IBTotalLabelObj As Label = DirectCast(RepeaterRow.FindControl("IBTotalLabel"), Label)
            Dim YearDepLabelObj As Label = DirectCast(RepeaterRow.FindControl("YearDepLabel"), Label)
            Dim AckDepLabelObj As Label = DirectCast(RepeaterRow.FindControl("AckDepLabel"), Label)
            Dim AccTotalLabelObj As Label = DirectCast(RepeaterRow.FindControl("AccTotalLabel"), Label)

            If Not PPpriceLabelObj.Text = Nothing Then
                AnlaggningarTable.DefaultCell.HorizontalAlignment = ALIGN_LEFT
                AnlaggningarTable.AddCell(New Phrase(AssetAccountLiteralObj.Text, MiddleBoldText))
                AnlaggningarTable.AddCell(New Phrase(AssetTypeNameLiteralObj.Text, MiddleBoldText))
                AnlaggningarTable.AddCell("")
                AnlaggningarTable.AddCell("")
                AnlaggningarTable.AddCell("")
                AnlaggningarTable.AddCell("")
                AnlaggningarTable.AddCell("")
                AnlaggningarTable.AddCell("")

                Dim ChildRow As Repeater = DirectCast(RepeaterRow.FindControl("childRepeater"), Repeater)

                ' Fill the report with child rows from the repeater control
                For Each ItemRow As RepeaterItem In ChildRow.Items
                    Dim AssetOwnIDLiteralObj As Literal = DirectCast(ItemRow.FindControl("AssetOwnIDLiteral"), Literal)
                    Dim AssetNameLiteralObj As Literal = DirectCast(ItemRow.FindControl("AssetNameLiteral"), Literal)
                    Dim PurchaseDateLiteralObj As Literal = DirectCast(ItemRow.FindControl("PurchaseDateLiteral"), Literal)
                    Dim PurchasePriceLiteralObj As Literal = DirectCast(ItemRow.FindControl("PurchasePriceLiteral"), Literal)
                    Dim YearIBLiteralObj As Literal = DirectCast(ItemRow.FindControl("YearIBLiteral"), Literal)
                    Dim YearDepLiteralObj As Literal = DirectCast(ItemRow.FindControl("YearDepLiteral"), Literal)
                    Dim SumAckDepricationLiteralObj As Literal = DirectCast(ItemRow.FindControl("SumAckDepricationLiteral"), Literal)
                    Dim AccountedValueLiteralObj As Literal = DirectCast(ItemRow.FindControl("AccountedValueLiteral"), Literal)

                    AnlaggningarTable.DefaultCell.HorizontalAlignment = ALIGN_LEFT
                    AnlaggningarTable.AddCell(New Phrase(AssetOwnIDLiteralObj.Text, MiddleText))
                    AnlaggningarTable.AddCell(New Phrase(AssetNameLiteralObj.Text, MiddleText))
                    AnlaggningarTable.AddCell(New Phrase(PurchaseDateLiteralObj.Text, MiddleText))
                    AnlaggningarTable.DefaultCell.HorizontalAlignment = ALIGN_RIGHT
                    AnlaggningarTable.AddCell(New Phrase(PurchasePriceLiteralObj.Text, MiddleText))
                    AnlaggningarTable.AddCell(New Phrase(YearIBLiteralObj.Text, MiddleText))
                    AnlaggningarTable.AddCell(New Phrase(YearDepLiteralObj.Text, MiddleText))
                    AnlaggningarTable.AddCell(New Phrase(SumAckDepricationLiteralObj.Text, MiddleText))
                    AnlaggningarTable.AddCell(New Phrase(AccountedValueLiteralObj.Text, MiddleText))
                Next

                ' Fill the pdf report with sum rows
                AnlaggningarTable.DefaultCell.HorizontalAlignment = ALIGN_LEFT
                AnlaggningarTable.AddCell(New Phrase("Sum", MiddleBoldText))
                AnlaggningarTable.AddCell("")
                AnlaggningarTable.AddCell("")
                AnlaggningarTable.DefaultCell.HorizontalAlignment = ALIGN_RIGHT
                AnlaggningarTable.AddCell(New Phrase(PPpriceLabelObj.Text, MiddleBoldText))
                AnlaggningarTable.AddCell(New Phrase(IBTotalLabelObj.Text, MiddleBoldText))
                AnlaggningarTable.AddCell(New Phrase(YearDepLabelObj.Text, MiddleBoldText))
                AnlaggningarTable.AddCell(New Phrase(AckDepLabelObj.Text, MiddleBoldText))
                AnlaggningarTable.AddCell(New Phrase(AccTotalLabelObj.Text, MiddleBoldText))
            End If
        Next

        ' Add the table to the pdf document
        PdfDocument.Add(AnlaggningarTable)

        ' End everything
        PdfDocument.Close()

        ' Open the generated pdf
        Response.ContentType = "Application/pdf"
        Response.AppendHeader("Content-Disposition", "attachment; filename=Assets.pdf")
        Response.Flush()
        Response.Close()

        ' IF YOU WANT A USER TO OPEN A PDF THAT IS SAVED ON THE WEBSERVER YOU CAN USE THIS CODE INSTEAD
        'Response.Clear()
        'Response.ContentType = "Application/pdf"
        'Response.AppendHeader("Content-Disposition", "attachment; filename=Assets.pdf")
        'Response.WriteFile(SavePdf)
        'Response.Flush()
        'Response.Close()

        ' IF YOU WANT TO DELETE A FILE ON THE WEBSERVER YOU CAN USE THIS CODE
        'Dim FileToDelete As FileInfo = New FileInfo(Server.MapPath("PathToFileAndFileName"))
        'If FileToDelete.Exists Then
        '    FileToDelete.Delete()
        'End If
    End Sub
End Class
